-------------------------------------------------------------------------------------------------------------------
-- REVISION 6 LUA Scripts (Ov3rHell3XoduZ)
-- OptionsRow Library for METRO QUAD
-------------------------------------------------------------------------------------------------------------------
local s = THEME:GetString('OptionNames','Start') .. " "

-------------------------------------------------------------------------------------------------------------------
-- Enable Mouse Cursor input.
-------------------------------------------------------------------------------------------------------------------
function MQMouseInput()
	local t = {
		Name = "MouseInput",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Enabled', 'Disabled' },
		LoadSelections = function(self, list, pn)
			local i = LoadFile("MouseInput.cfg","Settings") == "Enabled" and 1 or 2
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then WriteFile("MouseInput.cfg","Enabled","Settings") end
			if list[2] then WriteFile("MouseInput.cfg","Disabled","Settings") end
		end,
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- MenuTimer Type
-------------------------------------------------------------------------------------------------------------------
function MQTimerType()
	local t = {
		Name = "TimerType",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Timer', 'Countdown' },
		LoadSelections = function(self, list, pn)
			local i = LoadFile("TimerType.cfg","Settings") == "Timer" and 1 or 2
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then WriteFile("TimerType.cfg","Timer","Settings") end
			if list[2] then WriteFile("TimerType.cfg","Countdown","Settings") end
		end,
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- MenuTimer Normal
-------------------------------------------------------------------------------------------------------------------
function MQTimerNormal()
	local c = LoadFile("TimerNormal.cfg","Settings")
	local choice = ""
	if c == "300" then choice = "Infinite" else choice = (c - 1).." secs" end
	
	local t = {
		Name = "TimerNormal",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { "Time: "..choice, '30 secs', '60 secs', '90 secs', '120 secs', '150 secs', '180 secs', '210 secs', '240 secs', 'Infinite' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[2] then WriteFile("TimerNormal.cfg",31,"Settings") end
			if list[3] then WriteFile("TimerNormal.cfg",61,"Settings") end
			if list[4] then WriteFile("TimerNormal.cfg",91,"Settings") end
			if list[5] then WriteFile("TimerNormal.cfg",121,"Settings") end
			if list[6] then WriteFile("TimerNormal.cfg",151,"Settings") end
			if list[7] then WriteFile("TimerNormal.cfg",181,"Settings") end
			if list[8] then WriteFile("TimerNormal.cfg",211,"Settings") end
			if list[9] then WriteFile("TimerNormal.cfg",241,"Settings") end
			if list[10] then WriteFile("TimerNormal.cfg",300,"Settings") end
		end,
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- MenuTimer Countdown
-------------------------------------------------------------------------------------------------------------------
function MQTimerCountdown()
	local c = LoadFile("TimerCountdown.cfg","Settings")
	local choice = ""
	if c == "7500" then choice = "Infinite" else choice = SecondsToMMSS(c - 1) end
	
	local t = {
		Name = "TimerCountdown",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { "Time: "..choice, "10:00", "20:00", "30:00", "40:00", "50:00", "60:00", "70:00", "80:00", "90:00", "100:00", "110:00", "120:00", "Infinite" },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[2] then WriteFile("TimerCountdown.cfg",21,"Settings") end
			if list[3] then WriteFile("TimerCountdown.cfg",1201,"Settings") end
			if list[4] then WriteFile("TimerCountdown.cfg",1801,"Settings") end
			if list[5] then WriteFile("TimerCountdown.cfg",2401,"Settings") end
			if list[6] then WriteFile("TimerCountdown.cfg",3001,"Settings") end
			if list[7] then WriteFile("TimerCountdown.cfg",3601,"Settings") end
			if list[8] then WriteFile("TimerCountdown.cfg",4201,"Settings") end
			if list[9] then WriteFile("TimerCountdown.cfg",4801,"Settings") end
			if list[10] then WriteFile("TimerCountdown.cfg",5401,"Settings") end
			if list[11] then WriteFile("TimerCountdown.cfg",6001,"Settings") end
			if list[12] then WriteFile("TimerCountdown.cfg",6601,"Settings") end
			if list[13] then WriteFile("TimerCountdown.cfg",7201,"Settings") end
			if list[14] then WriteFile("TimerCountdown.cfg",7500,"Settings") end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- Debug Mode
-------------------------------------------------------------------------------------------------------------------
function MQDebugMode()
	local t = {
		Name = "DebugMode",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'On', 'Off' },
		LoadSelections = function(self, list, pn)
			local i = LoadFile("DebugMode.cfg","Settings") == "On" and 1 or 2
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then WriteFile("DebugMode.cfg","On","Settings") end
			if list[2] then WriteFile("DebugMode.cfg","Off","Settings") end
		end,
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- From Simply Love Port Theme (Thanks dbk2)
-- OptionRow: First ScreenPlayerOptions
-------------------------------------------------------------------------------------------------------------------
function ForwardOrBackward()
	local t = {
		Name = "Forward",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'SELECT MUSIC', 'ADVANCED MODIFIERS', 'FEATURES EFFECTS', 'GAMEPLAY' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then MetroQuad.Global.ScreenAfter.PlayerOptions = "ScreenSelectMusic" end
			if list[2] then MetroQuad.Global.ScreenAfter.PlayerOptions = "ScreenPlayerOptions2" end
			if list[3] then MetroQuad.Global.ScreenAfter.PlayerOptions = "ScreenPlayerOptions3" end
			if list[4] then MetroQuad.Global.ScreenAfter.PlayerOptions = "ScreenGameplay" end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- From Simply Love Port Theme (Thanks dbk2)
-- OptionRow: Second ScreenPlayerOptions
-------------------------------------------------------------------------------------------------------------------
function ForwardOrBackward2()
	local t = {
		Name = "Forward2",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'SELECT MUSIC', 'MAIN MODIFIERS', 'FEATURES EFFECTS', 'GAMEPLAY' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then MetroQuad.Global.ScreenAfter.PlayerOptions2 = "ScreenSelectMusic" end
			if list[2] then MetroQuad.Global.ScreenAfter.PlayerOptions2 = "ScreenPlayerOptions" end
			if list[3] then MetroQuad.Global.ScreenAfter.PlayerOptions2 = "ScreenPlayerOptions3" end
			if list[4] then MetroQuad.Global.ScreenAfter.PlayerOptions = "ScreenGameplay" end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- From Simply Love Port Theme (Thanks dbk2)
-- OptionRow: Third ScreenPlayerOptions
-------------------------------------------------------------------------------------------------------------------
function ForwardOrBackward3()
	local t = {
		Name = "Forward3",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'SELECT MUSIC', 'MAIN MODIFIERS', 'ADVANCED MODIFIERS', 'GAMEPLAY' },
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then MetroQuad.Global.ScreenAfter.PlayerOptions3 = "ScreenSelectMusic" end
			if list[2] then MetroQuad.Global.ScreenAfter.PlayerOptions3 = "ScreenPlayerOptions" end
			if list[3] then MetroQuad.Global.ScreenAfter.PlayerOptions3 = "ScreenPlayerOptions2" end
			if list[4] then MetroQuad.Global.ScreenAfter.PlayerOptions = "ScreenGameplay" end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- Score/Grade Weights
-------------------------------------------------------------------------------------------------------------------
function SetScoreGradeWeights()
	local Option = ThemePrefs.Get("ScoreGradeWeights")
	local t = {
		Name = "ScoreGradeWeights",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'METRO QUAD X', 'STEPMANIA 5' },
		LoadSelections = function(self, list, pn)
			if Option == "MQX" then list[1] = true else list[2] = true end
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				ThemePrefs.Set("ScoreGradeWeights","MQX") -- We set the ThemePref to "MQX".
				ThemePrefs.ForceSave() -- We Force to save in disk.
				SCREENMAN:SystemMessage("Score/Grade Weights set to \"Metro Quad X\"")
			end
			if list[2] then
				ThemePrefs.Set("ScoreGradeWeights","SM5") -- We set the ThemePref to "SM5".
				ThemePrefs.ForceSave() -- We Force to save in disk.
				SCREENMAN:SystemMessage("Score/Grade Weights set to \"Stepmania 5\"")
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- Timing Window.
-------------------------------------------------------------------------------------------------------------------
function SetTimingWindowValues()
	local Option = ThemePrefs.Get("TimingWindow")
	local t = {
		Name = "TimingWindow",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'METRO QUAD X', 'STEPMANIA 5' },
		LoadSelections = function(self, list, pn)
			if Option == "MQX" then list[1] = true else list[2] = true end
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				ThemePrefs.Set("TimingWindow","MQX") -- We set the ThemePref to "MQX".
				ThemePrefs.ForceSave() -- We Force to save in disk.
				PREFSMAN:SetPreference("TimingWindowSecondsW1",0.0125) -- We set the Preference to the corresponding value.
				PREFSMAN:SetPreference("TimingWindowSecondsW2",0.0250) -- We set the Preference to the corresponding value.
				PREFSMAN:SetPreference("TimingWindowSecondsW3",0.0500) -- We set the Preference to the corresponding value.
				PREFSMAN:SetPreference("TimingWindowSecondsW4",0.1000) -- We set the Preference to the corresponding value.
				PREFSMAN:SetPreference("TimingWindowSecondsW5",0) -- Bads will be disabled.
				PREFSMAN:SavePreferences() -- We Save preferences in disk.
				SCREENMAN:SystemMessage("Timing Windows set to \"Metro Quad X\"")
			end
			if list[2] then
				ThemePrefs.Set("TimingWindow","SM5") -- We set the ThemePref to "SM5".
				ThemePrefs.ForceSave() -- We Force to save in disk.
				PREFSMAN:SetPreference("TimingWindowSecondsW1",0.0225) -- We set the Preference to the corresponding value.
				PREFSMAN:SetPreference("TimingWindowSecondsW2",0.0450) -- We set the Preference to the corresponding value.
				PREFSMAN:SetPreference("TimingWindowSecondsW3",0.0900) -- We set the Preference to the corresponding value.
				PREFSMAN:SetPreference("TimingWindowSecondsW4",0.1350) -- We set the Preference to the corresponding value.
				PREFSMAN:SetPreference("TimingWindowSecondsW5",0.1800) -- We set the Preference to the corresponding value.
				PREFSMAN:SavePreferences() -- We Save preferences in disk.
				SCREENMAN:SystemMessage("Timing Windows set to \"Stepmania 5\"")
			end
		end
	}
	return t
end